from typing import Any


class BadRequestException(Exception):
    def __init__(self, endpoint: str, status_code: int, error_msg: str):
        self.status_code = status_code
        super().__init__(
            f"Request to Ghost API endpoint {endpoint} failed with status {status_code}: {error_msg}"
        )


class UnavailableAPIException(Exception):
    def __init__(self, status_code: int):
        self.status_code = status_code
        super().__init__(
            f"Ghost API is currently unavailable. Status code {status_code}"
        )


class NotFoundException(Exception):
    def __init__(self, object: Any, attr: dict[str, Any]):
        super().__init__(
            f"Could not find {type(object)} with the following attributes: {attr}"
        )


class GhostException(Exception):
    def __init__(self, message):
        super().__init__(message)
