from ghost.exceptions import GhostException


class BaseModel:
    printable = ["exists"]

    def __init__(self):
        self.exists = False

    def __str__(self):
        printable_str = [
            f"{k}={v}" for k, v in self.__dict__.items() if k in self.printable
        ]
        full_str = ", ".join(printable_str)
        return f"{type(self).__name__} <{full_str}>"

    def get(self):
        self.exists = True
        return self

    def create(self):
        if self.exists:
            raise GhostException(f"{type(self).__name__} already exists in Ghost")

        return self

    def update(self):
        if not self.exists:
            raise GhostException(
                f"Cannot update {type(self).__name__} that doesn't exist in Ghost yet"
            )

        return self

    def delete(self):
        if not self.exists:
            raise GhostException(
                f"Cannot delete {type(self).__name__} that doesn't exist in Ghost yet"
            )

        return self
