from fastapi import Header, Request, HTTPException
from pydantic import BaseModel
from os import getenv
import hmac
import json
import re


class MemberData(BaseModel):
    member: dict


async def webhook_authentication(request: Request, x_ghost_signature: str = Header()):
    if not x_ghost_signature:
        raise HTTPException(status_code=403)

    hmac_header_search = re.search("sha256=(.*), t=([0-9]*)", x_ghost_signature)
    if not hmac_header_search:
        raise HTTPException(status_code=403)

    sha256, timestamp = hmac_header_search.group(1, 2)

    raw_input = await request.body()
    input_hmac = hmac.new(
        key=getenv("GHOST_WEBHOOK_SECRET").encode(),
        msg=raw_input + timestamp.encode(),
        digestmod="sha256",
    )

    if not hmac.compare_digest(input_hmac.hexdigest(), sha256):
        raise HTTPException(status_code=401)

    return json.loads(raw_input)
